#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

PATH="/usr/sbin:/usr/bin:/sbin:/bin"

logfile="/var/log/$QLOUD_APPLICATION/access.log"

ts=$(date +%s)

timetail -n 60 -r '^tskv	tskv_format=xivahub-access-log	timestamp=(\d\d\d\d-\d\d-\d\d \d\d:\d\d:\d\d)' "$logfile" | head -n -1 | \
    tr '[:upper:]' '[:lower:]' | awk -F $'\t' -v ts="$ts" '
    @include "/usr/share/yandex-mail-common/metrics-util.awk"

    function print_passive_check(name, arr) {
        print "PASSIVE-CHECK:" name ";0;" (metrics["http.total"] ? metrics["http.total"] : 0) "," ( arr[name] ? arr[name] : 0 )
    }

    function reset_counter(code, service)
    {
        metrics["http.codes.service_total."code".tier_"service] = 0
        metrics["http.codes."request"."code".tier_"service] = 0
    }

    function init_codes(service)
    {
        if (!service) return
        if (!inited[service]) {
            inited[service] = 1
            reset_counter(200, service)
            reset_counter(429, service)
            reset_counter(500, service)
        }
    }

    BEGIN {
        metrics["http.codes.total.101"] = 0
        metrics["http.codes.total.200"] = 0
        metrics["http.codes.total.429"] = 0
        metrics["http.codes.total.500"] = 0
    }

    /request=/ {
        metrics["http.total"]++

        code = "unknown"
        service = ""
        request = ""
        exec_time = 0
        x_request_attempt = ""

        for (i=1; i <= NF; i++) {
            if ($i ~ /^status_code=/) {
                code = substr($i, 13)
                if (code < 100) next
            } else if ($i ~ /^service=/) {
                service = substr($i, 9)
            } else if ($i ~ /^request=/) {
                offset = length("request=") + 1
                end = index($i,"?")
                end = end > 0 ? end - offset : length($i)
                request = substr($i, offset, end)
                if (request ~ "/notify/") request = "notify"
                if (request ~ "/binary_notify/") request = "binary_notify"
                if (request ~ "/fast_notify/") request = "fast_notify"
                if (request ~ "/fast_binary_notify/") request = "fast_binary_notify"
                gsub("^(/)*","",request)
                gsub("[/]","_",request)
            } else if ($i ~ /^profiler_exec=/) {
                exec_time = substr($i, 15)
            } else if ($i ~ /^x_request_attempt=/) {
                x_request_attempt = substr($i, length("x_request_attempt=")+1)
            }
        }

        init_codes(service)

        if (x_request_attempt != "") {
            metrics["http.attempts."x_request_attempt]++
        }

        metrics["http.codes.total."code]++
        metrics["http.codes.service_total."code".tier_"service]++
        metrics["http.codes."request"."code".tier_"service]++
        if (code ~ /2../) {
            collect_timings(exec_time, "http.timings.total.tier_"service, metrics)
            collect_timings(exec_time, "http.timings."request".tier_"service, metrics)
        }
    }

    END {
        for (i in metrics) {
            value = metrics[i]
            if (i ~ /timings/) value = "["value"]"
            print i, value, ts
        }
    }
' | awk '
    match($1,/tier_/) {
        tier = substr($1, RSTART+RLENGTH)
        if (tier == "") tier = "none"
        print substr($1,1,RSTART-2), $2, $3, tier
    }
    !/tier_/ {
        print
    }
'