#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

PATH="/usr/sbin:/usr/bin:/sbin:/bin"

logfile="/var/log/$QLOUD_APPLICATION/db.log"

ts=$(date +%s)

timetail -n 60 -t imap "$logfile" | head -n -1 | \
    awk -F $'( |=)' -v ts="$ts" '

    @include "/usr/share/yandex-mail-common/metrics-util.awk"

    /ymod_pq request/ {
        db=$8
        req=$12
        tm=$15
        rows=$18
        if (tm+0!=tm) next
        tm /= 1000
        metrics["db.requests.total.tier_"db]++
        metrics["db.requests."req".tier_"db]++
        collect_timings(tm, "db.timings."req, metrics)
        collect_timings(tm, "db.timings.total.tier_"db, metrics)
        collect_values(rows, "db.rows."req, metrics)
    }

    /ymod_pq error/ {
        db=$8
        req=$15
        error_pos=match($0, "reason .*")
        if (error_pos > 0) {
            error_text=tolower(substr($0, RSTART+7, RLENGTH))
            # Since we already know query name, query text is redundant.
            query_text_pos=match(error_text, " query text.*")
            if (query_text_pos > 0) {
                error_text=substr(error_text, 0, query_text_pos-1)
            }
            gsub("[[:punct:][:space:]]", "_", error_text)
        } else {
            error_text="unknown"
        }
        metrics["db.errors.total.tier_"db]++
        metrics["db.errors."req"."error_text".tier_"db]++
    }

    END {
        values_to_hg("db.rows.", metrics)
        for (i in metrics) {
            value = metrics[i]
            if (i ~ /timings/) value = "["value"]"
            print i, value, ts
        }
    }
' | awk '
    match($1,/tier_/) {
        tier = substr($1, RSTART+RLENGTH)
        if (tier == "") tier = "none"
        print substr($1,1,RSTART-2), $2, $3, tier
    }
    !/tier_/ {
        print
    }
'
