#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

PATH="/usr/sbin:/usr/bin:/sbin:/bin"

metrics_awk='
@include "/usr/share/yandex-mail-common/metrics-util.awk"

match($0, /host=[.a-z0-9_-]+/) {
    parse(a)
    host = parse_host(substr($0, RSTART, RLENGTH))
    error = a["error"]
    gsub(" ", "_", error)

    print format("httpout.{}.total {}", host, 1)
    print format("httpout.{}.codes.{} {}", host, a["status"], 1)
    print format("httpout.{}.errors.{} {}", host, error, 1)
    print format("httpout.{}.bytes_out {}", host, a["bytes_out"])
    print format("httpout.{}.bytes_in {}", host, a["bytes_in"])
    print format("httpout.{}.attempts.{} {}", host, a["attempt"], 1)
    print format("httpout.{}.timings.resolve {}", host, a["resolve_time"])
    print format("httpout.{}.timings.connect {}", host, a["connect_time"])
    print format("httpout.{}.timings.tls {}", host, a["tls_time"])
    print format("httpout.{}.timings.total {}", host, a["total_time"])
}
'

log_file="/var/log/$QLOUD_APPLICATION/httpout.log"
aggregate_awk="/usr/share/yandex-mail-common/metrics-aggregate.awk"

timetail -n 30 -r 'timestamp=.{11}(\d\d:\d\d:\d\d)' "$log_file" | head -n -1 | \
    awk -F $'\t' "$metrics_awk" | fgrep -v '_qloud-c' | awk -v multiplier=2 -f "$aggregate_awk" | \
    awk -v ts="$(date +%s)" '{print $1, $2, ts, $3}'
