#! /bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

PATH="/usr/sbin:/usr/bin:/sbin:/bin"

ts=$(date +%s)

curl -s "localhost:980/status" > /tmp/status

convey_enabled=$(cat /tmp/status | jq '.convey_enabled')
delivery=$(cat /tmp/status | jq -r '.delivery')

if [[ "$convey_enabled" != "true" ]]; then
    echo "status.convey.disabled.$QLOUD_COMPONENT 1 $ts";
else
    echo "status.convey.disabled.$QLOUD_COMPONENT 0 $ts";
fi

if [[ "$delivery" == "weak" ]]; then
    echo "status.convey.weak.$QLOUD_COMPONENT 1 $ts";
else
    echo "status.convey.weak.$QLOUD_COMPONENT 0 $ts";
fi

if [[ "$delivery" == "forced weak" ]]; then
    echo "status.convey.forced_weak.$QLOUD_COMPONENT 1 $ts";
else
    echo "status.convey.forced_weak.$QLOUD_COMPONENT 0 $ts";
fi
