#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

PATH="/usr/sbin:/usr/bin:/sbin:/bin"

metrics_awk='
@include "/usr/share/yandex-mail-common/metrics-util.awk"

/group=notifications/ {
    status = "unknown"
    service = ""
    platform=""
    event = ""
    error = ""
    time_elapsed = ""
    delivery_mode = ""

    for (i=1; i <= NF; i++) {
        if ($i ~ /^status=/) {
            status = substr($i, length("status=")+1)
            gsub("(_|,| |-)", "", status)
        } else if ($i ~ /^service=/) {
            service = substr($i, length("service=")+1)
        } else if ($i ~ /^platform=/) {
            platform = substr($i, length("platform=")+1)
        } else if ($i ~ /^event=/) {
            event = substr($i, length("event=")+1)
            gsub("(_|,| |-)", "", event)
        } else if ($i ~ /^error=/) {
            error = substr($i, length("error=")+1)
            gsub("(_|,| |-)", "", error)
        } else if ($i ~ /^time_elapsed=/) {
            time_elapsed = substr($i, length("time_elapsed=")+1) / 1000
        } else if ($i ~ /^delivery_mode=/) {
            delivery_mode = substr($i, length("delivery_mode=")+1)
        } else if ($i ~ /^payload_sz=/) {
            payload_sz = substr($i, length("payload_sz=")+1)
        } else if ($i ~ /^repacked_size=/) {
            repacked_size = substr($i, length("repacked_size=")+1)
        } else if ($i ~ /^keys_sz=/) {
            keys_sz = substr($i, length("keys_sz=")+1)
        }
    }

    print format("notifications.total 1 {}", service)
    print format("notifications.status.{} 1 {}", status, service)
    print format("notifications.platformstatus.{}.{} 1 {}", platform, status, service)
    if (error) {
        print format("notifications.errors.{} 1 {}", error, service)
    }
    if (status == "conveyed" && time_elapsed) {
        print format("notifications.timings.{}.total {} {}", delivery_mode, time_elapsed, service)
        print format("notifications.timings.{}.{} {} {}", delivery_mode, platform, time_elapsed, service)
    }
    if (status == "conveyed") {
        print format("notifications.payload_sz.{}.total_hgram {} {}", delivery_mode, payload_sz, service)
        print format("notifications.repacked_size.{}.total_hgram {} {}", delivery_mode, repacked_size, service)
        print format("notifications.keys_sz.{}.total_hgram {} {}", delivery_mode, keys_sz, service)
    }
}
'

log_file="/var/log/$QLOUD_APPLICATION/typed.log"
aggregate_awk="/usr/share/yandex-mail-common/metrics-aggregate.awk"

timetail -n 30 -r 'timestamp=.{11}(\d\d:\d\d:\d\d)' "$log_file" | head -n -1 | \
    awk -F $'\t' "$metrics_awk" | awk -v multiplier=2 -f "$aggregate_awk" | \
    awk -v ts="$(date +%s)" '{print $1, $2, ts, $3}'
