#pragma once

#include "common.h"

namespace yxiva { namespace hub { namespace api {

struct add_broken_subscription : public api_coroutine
{
    std::shared_ptr<state> hub;
    expirable_stream_ptr stream;
    string platform;
    string id;
    std::time_t timestamp;

    void operator()(const error_code& err = {})
    {
        reenter(this)
        {
            if (timestamp == 0)
            {
                timestamp = time(nullptr);
            }

            yield hub->xtable->add_broken_subscription(
                stream->ctx(), platform, id, timestamp, *this);

            if (err)
            {
                YLOG_CTX_GLOBAL(stream->ctx(), error)
                    << "add_broken_subscription failed"
                    << " platform=" << platform << " id=" << id << " error=\"" << err << "\"";
                WEB_RESPONSE_CODE(stream, http_code_for_error(err), message_for_error(err));
            }
            else
            {
                YLOG_CTX_GLOBAL(stream->ctx(), debug) << "add_broken_subscription success"
                                                      << " platform=" << platform << " id=" << id;
                WEB_RESPONSE(stream, ok, "");
            }
        }
    }
};
}}}
