#pragma once

#include "common.h"
#include "hashing.h"
#include "batch_notify_coro.h"

namespace yxiva { namespace hub { namespace api {

struct batch_binary_notify : public api_coroutine
{
    std::shared_ptr<state> hub;
    expirable_stream_ptr stream;

    void operator()()
    {
        auto message = make_shared<yxiva::message>();
        batch_keys keys;
        auto& raw_body = stream->request()->raw_body;
        auto packed_data = string(raw_body.begin(), raw_body.end());
        size_t offset = 0;
        msgpack::unpacked unpacked_msg, unpacked_keys;
        try
        {
            msgpack::unpack(unpacked_msg, packed_data.data(), packed_data.size(), offset);
            unpacked_msg.get().convert(*message.get());
        }
        catch (const std::exception& e)
        {
            WEB_RESPONSE_LOG_G(info, stream, bad_request, "failed to unpack message");
            return;
        }
        try
        {
            msgpack::unpack(unpacked_keys, packed_data.data(), packed_data.size(), offset);
            unpacked_keys.get().convert(keys);
        }
        catch (const std::exception& e)
        {
            WEB_RESPONSE_LOG_G(info, stream, bad_request, "failed to unpack keys");
            return;
        }

        if (keys.empty())
        {
            WEB_RESPONSE_LOG_G(info, stream, bad_request, "no keys");
            return;
        }

        if (std::count_if(keys.begin(), keys.end(), [](const batch_key& key) -> bool {
                return key.uid.empty();
            }))
        {
            WEB_RESPONSE_LOG_G(info, stream, bad_request, "invalid keys");
            return;
        }

        hub->transport_log->new_notification(stream->ctx(), *message, true, hash(*message));

        batch_notify_coro coro = { {},      hub,  stream,
                                   message, keys, hub->settings->send_result_timeout_delta,
                                   {} };
        coro();
    }
};
}}}
