#pragma once

#include "common.h"

namespace yxiva { namespace hub { namespace api {

struct get_counters : public api_coroutine
{
    std::shared_ptr<state> hub;
    ymod_webserver::http::stream_ptr stream;
    string uid;
    std::vector<string> services;

    void operator()(
        const ymod_xstore::error& error = {},
        const ymod_xstore::counter_pack& counters = {})
    {
        reenter(this)
        {
            yield hub->xstore->get_counters(stream->ctx(), user_id(uid), services, *this);

            if (error)
            {
                YLOG_CTX_GLOBAL(stream->ctx(), error)
                    << "xstore read counters error: " << error.code.message();
                stream->result(
                    ymod_webserver::codes::internal_server_error, "xstore read counters error");
                return;
            }

            json_value json(json_type::tarray);
            try
            {
                for (auto it = counters.begin(); it != counters.end(); ++it)
                {
                    json_value counters_root;
                    json_value counters;
                    counters["count"] = it->second.count();
                    counters["top"] = it->second.top;
                    counters["seen"] = it->second.seen;
                    counters_root[it->first] = counters;
                    json.push_back(counters_root);
                }
            }
            catch (const std::exception& e)
            {
                YLOG_CTX_GLOBAL(stream->ctx(), error) << "get_counters exception: " << e.what();
                stream->result(
                    ymod_webserver::codes::internal_server_error, "get_counters internal error");
                return;
            }

            stream->result(ymod_webserver::codes::ok, yxiva::json_write(json));
        }
    }
};
}}}