#pragma once

#include "common.h"
#include <yxiva/core/message_to_json.h>

namespace yxiva { namespace hub { namespace api {

struct get_history : public api_coroutine
{
    std::shared_ptr<state> hub;
    ymod_webserver::http::stream_ptr stream;
    string uid;
    string service;
    local_id_t start_local_id;
    unsigned limit;
    time_t begin_ts;
    time_t end_ts;

    void operator()(const ymod_xstore::error& error = {}, ymod_xstore::entries_list_ptr list = {})
    {
        reenter(this)
        {
            stream->request()->context->profilers.push("xstore::read");
            yield hub->xstore->read(
                stream->ctx(),
                user_id(uid),
                service,
                start_local_id,
                limit,
                begin_ts,
                end_ts,
                *this);

            stream->request()->context->profilers.pop("xstore::read");

            if (error)
            {
                YLOG_CTX_GLOBAL(stream->ctx(), error)
                    << "xstore read error: " << error.code.message();
                stream->result(ymod_webserver::codes::internal_server_error, "xstore read error");
                return;
            }

            json_value json(json_type::tarray);
            try
            {
                if (list)
                {
                    for (auto it = list->begin(); it != list->end(); ++it)
                    {
                        yxiva::message msg;
                        unpack(it->content, msg);
                        msg.local_id = it->local_id;
                        msg.event_ts = it->event_ts;
                        json.push_back(yxiva::message_to_json(msg));
                    }
                }
            }
            catch (const std::exception& e)
            {
                YLOG_CTX_GLOBAL(stream->ctx(), error) << "get_history exception: " << e.what();
                stream->result(
                    ymod_webserver::codes::internal_server_error, "get_history internal error");
                return;
            }

            stream->result(ymod_webserver::codes::ok, json_write(json));
        }
    }
};
}}}
