#pragma once

#include <yxiva/core/message.h>
#include <yxiva/core/packing.hpp>
#include <yplatform/hash/sha1.h>
#include <msgpack/type.hpp>

namespace yxiva { namespace hub { namespace api {

struct deduplication_message_ref
{
    deduplication_message_ref(const message& source) : source(source)
    {
    }

    template <typename Packer>
    void msgpack_pack(Packer& pk) const
    {
        msgpack::type::make_define_array(source.operation, source.data, source.raw_data)
            .msgpack_pack(pk);
    }

    const message& source;
};

inline string hash(const message& message)
{
    return yplatform::sha1(pack(deduplication_message_ref(message)));
}

}}}