#pragma once

#include "common.h"

#define EMPTY_FILL(str) (str.empty() ? "-" : str)

namespace yxiva { namespace hub { namespace api {

struct list : public api_coroutine
{
    std::shared_ptr<state> hub;
    ymod_webserver::http::stream_ptr stream;
    string uid;
    string service;
    XTable::db_role db_role;

    auto find_options()
    {
        XTable::find_options options;
        options.show_inactive = true;
        options.db_role = db_role;
        return options;
    }

    void operator()(const error_code& err = {}, const sub_list& list = {})
    {
        reenter(this)
        {
            yield hub->xtable->find(stream->ctx(), uid, service, find_options(), *this);
            if (err)
            {
                stream->result(http_code_for_error(err), message_for_error(err));
                return;
            }

            std::ostringstream ss;
            ss << "id\thost\textra_data\tttl\tclient\tsession_key\tfilter\tinit_local_"
                  "id\tack_local_id\tplatform\tdevice\n";
            for (auto it = list.begin(); it != list.end(); ++it)
            {
                ss << EMPTY_FILL(it->id) << "\t" << EMPTY_FILL(it->callback_url) << "\t"
                   << EMPTY_FILL(it->extra_data) << "\t" << it->ttl << "\t"
                   << EMPTY_FILL(it->client) << "\t" << EMPTY_FILL(it->session_key) << "\t"
                   << EMPTY_FILL(it->filter) << "\t" << it->init_local_id << "\t"
                   << it->ack_local_id
                   << "\t"
                   // Keep unresolved values while all components are migrating.
                   << platform::hacks::fcm_to_gcm(it->platform) << "\t" // gcm_compatibility
                   << it->device;
                ss << "\n";
            }
            stream->result(ymod_webserver::codes::ok, ss.str());
        }
    }
};

}}}
