#include "list_json.h"

#include <yxiva/core/platforms.h>

namespace yxiva { namespace hub { namespace api {

void send_list_json(ymod_webserver::http::stream_ptr stream, const sub_list& list)
{
    json_value result(json_type::tarray);
    for (auto it = list.begin(); it != list.end(); ++it)
    {
        json_value item;
        item["uid"] = it->uid;
        item["service"] = it->service;
        item["id"] = it->id;
        item["url"] = it->callback_url;
        item["extra_data"] = it->extra_data;
        item["ttl"] = it->ttl;
        item["client"] = it->client;
        item["session_key"] = it->session_key;
        item["filter"] = it->filter;
        item["init_local_id"] = it->init_local_id;
        item["init_time"] = it->init_time;
        item["ack_local_id"] = it->ack_local_id;
        item["ack_time"] = it->ack_time;
        // Keep unresolved values while all components are migrating.
        item["platform"] = platform::hacks::fcm_to_gcm(it->platform); // gcm_compatibility
        item["device"] = it->device;
        item["connection_id"] = it->bb_connection_id;
        item["retry_interval"] = static_cast<uint64_t>(it->retry_interval);
        item["next_retry_time"] = it->next_retry_time;
        item["ack_event_ts"] = it->ack_event_ts;
        result.push_back(item);
    }

    stream->result(ymod_webserver::codes::ok, json_write_styled(result));
}

}}}
