#pragma once

#include "common.h"

namespace yxiva { namespace hub { namespace api {

struct repeat_messages : public api_coroutine
{
    std::shared_ptr<state> hub;
    ymod_webserver::http::stream_ptr stream;
    string uid;
    string service;
    local_id_t position;
    local_id_t count;

    void operator()(const ymod_xstore::error& err = {}, unsigned long repeated_count = 0)
    {
        reenter(this)
        {
            yield hub->xstore->lift_messages(stream->ctx(), uid, service, position, count, *this);

            if (err)
            {
                YLOG_CTX_GLOBAL(stream->ctx(), error)
                    << "xstore lift error: " << err.code.message();
                return stream->result(codes::internal_server_error, "xstore lift failed");
            }
            // Create task even if no messages were lifted
            // in case we're dealing with retry after failed create_xtask.
            hub->xtasks->create_task(
                stream->ctx(),
                // task_position is an estimate of last message local_id + 1 to create
                // task.
                ymod_xtasks::task_draft{
                    uid, service, position + count + 1, "", ymod_xtasks::delay_flags::none },
                [stream = this->stream, repeated_count](const auto& err) {
                    if (err)
                    {
                        YLOG_CTX_GLOBAL(stream->ctx(), error)
                            << "xtask create error: " << err.code.message();
                        stream->result(codes::internal_server_error, "xtask create failed");
                    }
                    else
                    {
                        stream->result(codes::ok, std::to_string(repeated_count));
                    }
                });
        }
    }
};
}}}
