#include "control.h"
#include <yxiva/core/shards/merging_storage.h>

namespace yxiva { namespace hub { namespace api { namespace resharding {

controller::request_reaction request_reaction_from_string(const string& s)
{
    using r = controller::request_reaction;
    if (s == "delay")
    {
        return r::delay;
    }
    if (s == "reject")
    {
        return r::reject;
    }
    throw std::invalid_argument(string("invalid resharding request_reaction value ") + s);
}

controller::role role_from_string(const string& s)
{
    using r = controller::role;
    if (s == "master")
    {
        return r::master;
    }
    if (s == "slave")
    {
        return r::slave;
    }
    throw std::invalid_argument(string("invalid resharding role value ") + s);
}

}}}}
