#pragma once

#include "common.h"

namespace yxiva { namespace hub { namespace api {

struct send : public api_coroutine
{
    std::shared_ptr<state> hub;
    expirable_stream_ptr stream;
    std::vector<sub_t> subscriptions = {};
    shared_ptr<yxiva::message> message = { make_shared<yxiva::message>() };

    void operator()(const error_code& err = {}, const string& = {})
    {
        subscriptions.resize(1);
        auto& subscription = subscriptions.front();

        reenter(this)
        {
            try
            {
                auto& raw_body = stream->request()->raw_body;
                auto packed_data = string(raw_body.begin(), raw_body.end());
                size_t offset = 0;
                msgpack::unpacked unpacked_msg, unpacked_sub;
                msgpack::unpack(unpacked_msg, packed_data.data(), packed_data.size(), offset);
                msgpack::unpack(unpacked_sub, packed_data.data(), packed_data.size(), offset);
                unpacked_msg.get().convert(*message.get());
                unpacked_sub.get().convert(subscription);
                subscription.platform =
                    platform::resolve_alias(subscription.platform).name; // gcm_compatibility
            }
            catch (const std::exception& e)
            {
                WEB_RESPONSE_LOG_G(info, stream, bad_request, "failed to unpack body");
                return;
            }

            if (subscription.uid != message->uid || subscription.service != message->service)
            {
                WEB_RESPONSE_LOG_G(info, stream, bad_request, "uid or service mismatch");
                return;
            }

            // Store data in convey context to prevent its destroy while exhaust
            // is running background operations (update or unsubscribe).
            yield
            {
                auto convey_ctx = boost::make_shared<convey_context>(
                    stream->ctx(), message, std::move(subscriptions));
                hub->exhaust->send(
                    ::yxiva::packet(
                        convey_ctx, *convey_ctx->message, convey_ctx->subscriptions.front()),
                    false,
                    *this);
            }
            WEB_RESPONSE_CODE(stream, http_code_for_error(err), message_for_error(err));
        }
    }
};
}}}
