#include "shards.h"
#include <yxiva/core/shards/shards.h>
#include <boost/property_tree/json_parser.hpp>
#include <sstream>

namespace yxiva { namespace hub { namespace api { namespace detail {

json_value to_short_json(const shard_config::shards& shards)
{
    json_value shards_node;
    for (auto& shard : shards)
    {
        shards_node[shard.describe()] = json_value();
        auto&& shard_node = shards_node[shard.describe()];
        shard_node["master"] = shard.master.conninfo;
        auto&& replicas_node = shard_node["replicas"];
        replicas_node.set_array();
        for (auto& replica : shard.replicas)
        {
            replicas_node.push_back(replica.conninfo);
        }
    }
    return shards_node;
}

}}}}
