#pragma once

#include "common.h"
#include <yxiva/core/shards/shards.h>

namespace yxiva { namespace hub { namespace api {
namespace detail {

json_value to_short_json(const shard_config::shards& shards);

}

template <typename Module>
struct shards : public api_coroutine
{
    std::shared_ptr<state> hub;
    ymod_webserver::http::stream_ptr stream;
    bool human_readable;

    void operator()()
    {
        reenter(this)
        {
            auto shards = get_module()->shards()->get();
            auto shards_json = human_readable ? detail::to_short_json(*shards) : to_json(*shards);
            stream->result(ymod_webserver::codes::ok, json_write_styled(shards_json));
        }
    }

    const shared_ptr<Module>& get_module()
    {
        if constexpr (std::is_same_v<Module, XTable>)
        {
            return hub->xtable;
        }
        else if constexpr (std::is_same_v<Module, ymod_xstore::xstore>)
        {
            return hub->xstore;
        }
        else
        {
            // Common workaround, cannot just say "false",
            // the expression needs to be type dependent.
            static_assert(std::is_void_v<Module>, "unknown module");
        }
    }
};

}}}
