#pragma once

#include "common.h"

namespace yxiva { namespace hub { namespace api {

struct status : public api_coroutine
{
    std::shared_ptr<state> hub;
    ymod_webserver::http::stream_ptr stream;

    void operator()()
    {
        auto paxos_node = yplatform::find<ymod_paxos::node>("paxos_node");
        auto paxos_node_status = paxos_node->get_status();

        json_value json;

        json["xtasks"]["status"] = paxos_node_status.status;
        json["xtasks"]["revision"] = paxos_node_status.revision;
        json["xtasks"]["master"] = paxos_node_status.is_master;
        json["xtasks"]["master_available"] = paxos_node_status.master_available;
        json["lease"]["node_id"] = hub->lease_node->node_id();
        json["convey_enabled"] = hub->stats.convey_enabled ? true : false;
        json["control_leader"] = hub->stats.control_leader ? true : false;
        json["ignore_xstore_errors"] = hub->stats.ignore_xstore_errors ? true : false;
        json["manual_xtasks_degradation"] = hub->stats.manual_xtasks_degradation ? true : false;
        json["manual_xstore_degradation"] = hub->stats.manual_xstore_degradation ? true : false;
        json["delivery"] = hub->stats.robust_delivery ?
            "robust" :
            (hub->settings->force_weak_delivery ? "forced weak" : "weak");
        stream->result(ymod_webserver::codes::ok, json_write_styled(json));
    }
};
}}}
