#include "subscribe.h"

#include <yxiva/core/filter.h>
#include <boost/algorithm/string/classification.hpp>

namespace yxiva { namespace hub { namespace api {

using ymod_webserver::http::expirable_stream_ptr;

namespace detail {
void correct_range(
    local_id_t range_bottom,
    local_id_t range_top,
    local_id_t& position,
    unsigned& count)
{
    if (range_bottom && range_top && position < range_top)
    {
        // Subtracting 1 from range_bottom, because position is exclusive,
        // but range_bottom is inclusive (position looks at the first message
        // we do not want to send, but range_bottom looks at the first message
        // we do want to send).
        count = static_cast<unsigned>(
            std::min<local_id_t>((count), range_top - std::max(range_bottom - 1, position)));
        position = std::max(position, range_top - count);
    }
    else
    {
        count = 0;
        position = range_top;
    }
}

operation::result extract_appname(const sub_t& sub, string& appname)
{
    using namespace yxiva::callback_uri;
    string ignored;
    if (is_mobile_uri(sub.callback_url))
    {
        return parse_mobile_uri(sub.callback_url, appname, ignored);
    }
    else if (is_apns_queue_uri(sub.callback_url))
    {
        return parse_apns_queue_uri(sub.callback_url, ignored, appname, ignored);
    }
    else
    {
        return operation::result("inappropriate uri type");
    }
}

bool push_tokens_match(const sub_t& lhs, const sub_t& rhs)
{
    using namespace yxiva::callback_uri;

    if (!is_mobile_uri(lhs.callback_url) || !is_mobile_uri(rhs.callback_url))
    {
        return false;
    }
    string lhs_appname, rhs_appname, lhs_pushtoken, rhs_pushtoken;
    if (!parse_mobile_uri(lhs.callback_url, lhs_appname, lhs_pushtoken) ||
        !parse_mobile_uri(rhs.callback_url, rhs_appname, rhs_pushtoken))
    {
        return false;
    }
    return lhs_pushtoken == rhs_pushtoken && lhs_appname == rhs_appname;
}

bool devices_appnames_match(const sub_t& lhs, const sub_t& rhs)
{
    if (lhs.device.empty() || rhs.device.empty())
    {
        return false;
    }
    string lhs_appname, rhs_appname;
    if (!extract_appname(lhs, lhs_appname) || !extract_appname(rhs, rhs_appname))
    {
        return false;
    }
    return lhs.device == rhs.device && lhs_appname == rhs_appname;
}
}

}}}
