#pragma once

#include "common.h"

namespace yxiva { namespace hub { namespace api {

struct unsubscribe_overlapped : public api_coroutine
{
    std::shared_ptr<state> hub;
    ymod_webserver::http::stream_ptr stream;
    string uid;
    string service;
    unsigned overlap;
    string subscription_id;

    void operator()(const error_code& ec = {}, const string& /*subscription_id*/ = {})
    {
        reenter(this)
        {
            yield hub->xtable->unsubscribe_overlapped(
                stream->ctx(), uid, service, subscription_id, overlap, *this);
            if (ec)
            {
                stream->result(http_code_for_error(ec), message_for_error(ec));
                return;
            }
            stream->result(ymod_webserver::codes::ok, "");
        }
    }
};
}}}
