#pragma once

#include "common.h"

namespace yxiva { namespace hub { namespace api {

struct update_callback_uidset : public api_coroutine
{
    std::shared_ptr<state> hub;
    expirable_stream_ptr stream;
    string uidset;
    string service;
    string callback;
    size_t i = 0;
    sub_list uidset_list = {};

    // XXX copy pasted from list
    auto find_options()
    {
        XTable::find_options options;
        options.show_inactive = true;
        return options;
    }

    void operator()(const error_code& err = {}, const sub_list& list = {})
    {
        reenter(this)
        {
            yield hub->xtable->update_uidset(stream->ctx(), uidset, service, "", callback, *this);

            if (err)
            {
                hub->transport_log->update_callback_failed(
                    stream->ctx(), uidset, service, message_for_error(err), "", callback);
                return stream->result(http_code_for_error(err), message_for_error(err));
            }

            hub->transport_log->update_callback_finished(
                stream->ctx(), uidset, service, "", callback);

            yield hub->xtable->find_uidset(stream->ctx(), uidset, service, find_options(), *this);

            if (err)
            {
                return stream->result(http_code_for_error(err), message_for_error(err));
            }

            uidset_list = list;

            for (i = 0; i < uidset_list.size(); ++i)
            {
                yield
                {
                    stream->context()->profilers.push("xtasks::create");
                    auto delay_flags = ymod_xtasks::delay_flags::wakeup_on_create |
                        ymod_xtasks::delay_flags::ignore_if_pending;
                    ymod_xtasks::task_draft draft = { uidset_list[i].uid,
                                                      uidset_list[i].service,
                                                      uidset_list[i].ack_local_id,
                                                      "",
                                                      delay_flags };
                    hub->xtasks->create_task(stream->context(), draft, *this);
                }
                stream->context()->profilers.pop("xtasks::create");
                if (err)
                {
                    hub->transport_log->subscribe_task_create_failed(
                        stream->ctx(), uidset_list[i], err.message());
                    return;
                }
                hub->transport_log->subscribe_task_created(stream->ctx(), uidset_list[i]);
            }
            return stream->result(http_code_for_error(err), message_for_error(err));
        }
    }

    // xtasks.create handler
    void operator()(const ymod_xtasks::error& err)
    {
        (*this)(err.code);
    }
};
}}}
