#pragma once

#include "settings.h"
#include "state.h"
#include "stats.h"

#include <yxiva/core/types.h>
#include <sintimers/timers_queue_interface.h>

namespace yxiva { namespace hub {

/**
 * Hub may be a control leader. The control module does leader election
 * and some leader's functions:
 * - stores cluster configuration in leasemeta cluster
 * - propagates cluster settings (delivery mode)
 * - monitors xtasks errors and automatically switches cluster to fallback mode
 *
 * Followers:
 * - pick delivery mode from leasemeta
 * - apply network topology received from leasemeta cluster
 */
class control_module
    : public yplatform::log::contains_logger
    , public std::enable_shared_from_this<control_module>
{
public:
    using topology_validator =
        std::function<bool(const std::set<peer_info>&, const std::set<peer_info>&)>;

    control_module(yplatform::reactor&, std::shared_ptr<state>);

    void init();
    void start();
    void stop();

    bool async_set_robust_delivery(bool enabled);

    // Validation might be done in strand so we need an external validator.
    bool async_set_topology(
        const std::set<peer_info>& topology,
        const topology_validator& validate_func);

private:
    void handle_lease(const ymod_lease::node_id&, const ymod_lease::value&);

    void reconfigure_network();

    void observe_timer_start();
    void observe_timer_stop();
    void handle_observe_timer();
    void update_xtasks_parameters();
    void try_enable_robust_delivery();
    void try_disable_robust_delivery();
    void sample_xtasks();
    unsigned count_xtasks_bad_samples();

    boost::asio::io_service::strand strand_;
    std::shared_ptr<state> state_;
    timers::queue_ptr timers_;
    timers::timer_ptr observe_timer_;
    string my_address_;
    cluster_metadata cluster_metadata_;
};

}}
