#pragma once

#include "../error.h"
#include "gate.h"
#include "mobile_gate.h"
#include <yxiva/core/json.h>
#include <yxiva/core/message.h>
#include <yxiva/core/types.h>
#include <yxiva/core/repacker.h>
#include <ymod_httpclient/cluster_client.h>
#include <yplatform/util/safe_call.h>

namespace yxiva { namespace hub {

class apns_queue_gate
{
    using handler_t = std::function<void(gate_response)>;

    class task
    {
    public:
        task(const packet& packet, const handler_t& handler)
            : packet(packet), sub(packet.subscription), handler(handler)
        {
            // Extract repacking rules for push service params for further use.
            auto it = packet.message.repacking_rules.find(sub.platform);
            if (it != packet.message.repacking_rules.end())
            {
                json_value rules;
                if (json_parse(rules, it->second))
                {
                    rules.remove_member("repack_payload");
                    repack = json_write(rules);
                }
            }
        }

        void result(gate_result result, const string& data)
        {
            // Call handler only once (for bright notification or for the last one).
            if (!result_sent)
            {
                result_sent = true;
                yplatform::safe_call(handler, gate_response{ result, data, {} });
            }
        }

        packet packet;
        apns_queue_sub_t sub;
        string repack;
        push_requests_queue requests;

    private:
        handler_t handler;
        bool result_sent = false;
    };

public:
    apns_queue_gate(yplatform::reactor& reactor, const apns_queue_gate_settings& settings);
    void send_message(const packet& packet, const handler_t& handler);

private:
    void handle_list(
        std::shared_ptr<task> task,
        const boost::system::error_code& ec,
        yhttp::response response);
    void do_send(std::shared_ptr<task> task);
    void handle_send(
        std::shared_ptr<task> task,
        bool bright,
        const boost::system::error_code& ec,
        yhttp::response response);
    yhttp::request prepare_list(const apns_queue_sub_t& sub);
    operation::result prepare_message(std::shared_ptr<task> task, message& message, bool bright);
    yhttp::request prepare_notify(const apns_queue_sub_t& sub, const message& msg, string url);

    const apns_queue_gate_settings settings_;
    yhttp::cluster_client http_client_;
};

}}
