#pragma once

#include "../error.h"
#include "convey_context.h"
#include "gate.h"
#include <yxiva/core/message.h>

namespace yxiva { namespace hub {

struct send_data
{
    send_data(
        const convey_context_ptr& ctx,
        const sub_t& subscription,
        bool bright,
        const convey_callback_t& cb)
        : ctx(ctx), pkt(ctx, *ctx->message, subscription), cb(cb)
    {
        if (!bright)
        {
            pkt.mark_silent_delivery();
        }
    }

    convey_context_ptr ctx;
    packet pkt;
    convey_callback_t cb;
};

using data_ptr = std::shared_ptr<send_data>;

struct fcm_batch_data;
using fcm_batch_data_ptr = std::shared_ptr<fcm_batch_data>;
using fcm_batch_callback_t = std::function<void(const fcm_batch_data_ptr&, size_t, gate_response)>;

struct fcm_batch_data
{
    convey_context_ptr ctx;
    std::vector<sub_t*> subscriptions;
    string app_name;
    fcm_batch_callback_t cb;
    push_requests_queue req;
    string tokens;
    bool bright{ true };
    // Fields containing data for logging and other uses.
    std::map<string, string> fields;
};

template <typename BatchData>
using batch_range = std::shared_ptr<std::vector<BatchData>>;

}}
