#pragma once

#include <yxiva/core/types.h>
#include <yxiva/core/message.h>
#include <yxiva/core/repacker.h>
#include <yxiva/core/subscriptions.h>
#include <yplatform/task_context.h>
#include <yplatform/context_repository.h>
#include <yplatform/log.h>
#include <atomic>

namespace yxiva { namespace hub {

typedef std::function<void(const error_code& err, const string&)> convey_callback_t;

class convey_context : public yplatform::task_context
{
public:
    convey_context(task_context_ptr ctx, shared_ptr<message> message, const sub_list& subscriptions)
        : yplatform::task_context(*ctx)
        , ctx(ctx)
        , message(message)
        , subscriptions(subscriptions)
        , cache(std::make_shared<push_request_cache>())
        , own_context_(boost::make_shared<task_context>())
    {
        context_repo.add_context(own_context_);
    }

    ~convey_context()
    {
        try
        {
            context_repo.rem_context(own_context_);
        }
        catch (const std::exception& e)
        {
            YLOG_CTX_GLOBAL(ctx, error) << "rem_context exception " << e.what();
        }
    }

    task_context_ptr ctx;
    shared_ptr<::yxiva::message> message;
    sub_list subscriptions;
    push_request_cache_ptr cache;

private:
    // cannot register ctx (because it's registration is managed elsewhere)
    // or shared_from_this() (because we want to unregister in destructor)
    // so use a separate context to make yplatform wait for convey completion on stop
    task_context_ptr own_context_;
};

typedef boost::shared_ptr<convey_context> convey_context_ptr;

} // namespace hub
} // namespace yxiva
