#pragma once

#include <map>

#include <boost/xpressive/xpressive.hpp>

namespace yxiva { namespace util {

using namespace boost::xpressive;

class dictionary_templater
{

public:
    typedef std::map<string, string> map_t;

    dictionary_templater(string element_pattern = R"(\$\{([\w\-]+)\})")
    {
        element_regex = sregex::compile(element_pattern);
    }

    string format(string const& template_str, map_t const& values)
    {
        std::function<string(smatch const&)> formatter =
            boost::bind(&dictionary_templater::format_callback, this, boost::ref(values), _1);
        return regex_replace(template_str, element_regex, formatter);
    }

private:
    string format_callback(map_t const& values, smatch const& match)
    {
        auto value_it = values.find(match[1].str());
        if (value_it != values.end()) return value_it->second;

        return match[1].str();
    }

private:
    sregex element_regex;
};

}}