#pragma once

#include "../error.h"
#include "xtable/xtable.h"
#include "convey_context.h"
#include "gate.h"
#include "http_gate.h"
#include "mobile_gate.h"
#include "webpush_gate.h"
#include "apns_queue_gate.h"
#include "send_processor.h"
#include "settings.h"
#include "mod_log/mod_log.h"
#include <yxiva/core/types.h>
#include <yxiva/core/parameter_names.h>
#include <yxiva/core/message.h>
#include <boost/system/error_code.hpp>
#include <atomic>
#include <vector>

namespace yxiva { namespace hub {

typedef std::function<void(const error_code& code, const sub_t& subscription, const string& body)>
    report_callback_t;

class exhaust : public yplatform::module
{
public:
    exhaust(yplatform::reactor& reactor);

    void init(const yplatform::ptree& conf);

    void start();

    void fini();

    yplatform::ptree get_stats() const override;

    // send method for weak delivery in /notify
    void convey(
        task_context_ptr ctx,
        shared_ptr<message> message,
        const convey_callback_t& cb = convey_callback_t());

    void convey(convey_context_ptr ctx, const report_callback_t& report_cb);

    // send a message to a single subscription
    // updates position after send if update is true
    // unsubscribes if subscriber answers with special code
    void send(
        const packet& packet,
        bool update,
        const convey_callback_t& cb,
        push_request_cache* cache = nullptr);

    void batch_convey(convey_context_ptr ctx, const report_callback_t& report_cb);

    const time_duration& send_timeout_for(const sub_t& subscription) const;

private:
    void handle_list(
        task_context_ptr ctx,
        shared_ptr<message> message,
        const error_code& err,
        const sub_list& list,
        convey_callback_t& cb);

    void handle_gate_send(
        const packet& packet,
        gate_response resp,
        bool update,
        const convey_callback_t& cb);

    void handle_callback_update(const packet& packet, const error_code& error);
    void handle_unsubscribe(const packet& packet, const error_code& error);

    void handle_update(
        const packet& packet,
        const error_code& error,
        bool exists,
        local_id_t local_id);

    yplatform::reactor_ptr reactor_;
    xtable_ptr xtable_;
    boost::shared_ptr<mod_log> mod_log_;
    std::shared_ptr<http_gate> http_gate_;
    std::shared_ptr<http_gate> ws_gate_;
    std::shared_ptr<mobile_gate> mobile_gate_;
    std::shared_ptr<webpush_gate> webpush_gate_;
    std::shared_ptr<apns_queue_gate> apns_queue_gate_;
    std::shared_ptr<batch_processor> send_proc_;
    std::shared_ptr<fcm_batch_processor> fcm_proc_;
    exhaust_settings settings_;
};

typedef boost::shared_ptr<exhaust> exhaust_ptr;

}}
