#pragma once

#include "convey/batch_data.h"
#include <boost/algorithm/string/join.hpp>

namespace yxiva { namespace hub {

class fcm_batch_aggregator
{
public:
    using key_t = std::tuple<string, bool>;
    using data_t = std::vector<fcm_batch_data_ptr>;
    using data_ptr = std::shared_ptr<data_t>;

    fcm_batch_aggregator(size_t max_batch_size)
        : data(std::make_shared<data_t>()), max_batch_size(max_batch_size)
    {
    }

    void add(
        sub_t& sub,
        const push_subscription_params& mob_sub,
        bool bright,
        const push_requests_queue& req,
        const convey_context_ptr& ctx,
        const fcm_batch_callback_t& cb)
    {
        auto& val = storage[std::tie(mob_sub.app_name, bright)];
        if (!val)
        {
            val = std::make_shared<fcm_batch_data>();
            val->app_name = mob_sub.app_name;
            val->ctx = ctx;
            val->req = req;
            val->cb = cb;
            val->bright = bright;
            val->fields["bright_push"] = req.is_bright() ? "true" : "false";
            val->fields["repacked_size"] = std::to_string(req.payload_size());
            val->tokens.append("[\"");
        }
        else
        {
            val->tokens.append(",\"");
        }
        val->tokens.append(mob_sub.push_token).append("\"");
        val->subscriptions.push_back(&sub);
        if (val->subscriptions.size() >= max_batch_size)
        {
            val->tokens.append("]");
            data->push_back(val);
            storage.erase(std::tie(mob_sub.app_name, bright));
        }
    }

    data_ptr get_all()
    {
        for (const auto& el : storage)
        {
            el.second->tokens.append("]");
            data->push_back(el.second);
        }
        storage.clear();
        return data;
    }

private:
    std::map<key_t, fcm_batch_data_ptr> storage;
    data_ptr data;
    size_t max_batch_size;
};

}}
