#pragma once

#include <yxiva/core/types.h>
#include <yxiva/core/message.h>
#include <yplatform/log.h>

namespace yxiva { namespace hub { namespace hacks {

inline bool need_dump_request(const packet& packet)
{
    return packet.service == "bass";
}

template <typename R>
inline void dump_request(R&& requests, const string& transit_id)
{
    if (requests.empty()) return;
    YLOG_G(info) << "request dump transit_id=" << transit_id
                 << " params=" << requests.front().http_url_params()
                 << " payload=" << requests.front().payload();
}

}}}