#pragma once

#include "gate.h"
#include "../error.h"
#include "convey_context.h"
#include "dictionary_templater.h"
#include "settings.h"
#include <yxiva/core/types.h>
#include <yxiva/core/message.h>
#include <yxiva/core/packing.hpp>
#include <yxiva/core/parameter_names.h>
#include <ymod_httpclient/client.h>
#include <vector>

namespace yxiva { namespace hub {

using yxiva::util::dictionary_templater;

class http_gate
{
    typedef yhttp::call http_client_t;

public:
    static const size_t DEFAULT_MAXIMUM_PASSED_BODY_LEN;
    typedef gate_result result;
    using handler_type = std::function<void(const gate_response&)>;

    http_gate(yplatform::reactor& reactor, const http_gate_settings& settings);

    void send_message(const packet& packet, const handler_type& handler);

    const time_duration& send_timeout_for(const sub_t& subscription) const;

private:
    string prepare_callback(const sub_t& subscription);

    void handle_http_call(
        const boost::system::error_code& ec,
        yhttp::response response,
        const handler_type& handler);

private:
    const http_gate_settings settings_;
    yhttp::client http_client_;
    yhttp::options http_options_;
    dictionary_templater templater_;
};

}}
