#pragma once

#include "gate.h"
#include "../error.h"
#include "settings.h"
#include <yxiva/core/types.h>
#include <yxiva/core/message.h>
#include <yxiva/core/repacker.h>
#include <yxiva/core/operation_result.h>
#include <ymod_httpclient/cluster_client.h>
#include <ymod_httpclient/response/string_data_handler.h>

namespace yxiva { namespace hub {

class mobile_gate
{
    typedef ymod_http_client::remote_point_info_ptr host_info_ptr;

public:
    typedef gate_result result;
    using handler_type = std::function<void(gate_response)>;

    mobile_gate(yplatform::reactor& reactor, const mobile_gate_settings& st);

    void send_message(const packet& packet, push_request_cache* cache, const handler_type& handler);
    const time_duration& send_timeout_for(const sub_t& subscription) const;

private:
    struct context
    {
        context(const task_context_ptr& ctx, const sub_t& sub) : ctx(ctx), subscription(sub)
        {
            fields["app_name"] = subscription.app_name;
        }

        task_context_ptr ctx;
        push_subscription_params subscription;
        push_requests_queue messages;
        string url;
        string body;
        std::map<string, string> fields;
    };

    void do_send(std::shared_ptr<context> gate_req, const handler_type& handler);
    void handle_send(
        const boost::system::error_code& ec,
        yhttp::response response,
        std::shared_ptr<context> gate_req,
        const handler_type& handler);
    void prepare_request_url(const std::shared_ptr<context>& gate_req, const packet& packet) const;

private:
    const mobile_gate_settings settings_;
    yhttp::cluster_client http_client_;
    yhttp::cluster_client::options http_options_;
    yhttp::cluster_client::options http_options_windows_;
};

}}