#pragma once

#include "gate.h"
#include "../error.h"
#include "settings.h"
#include <yxiva/core/message.h>
#include <yxiva/core/operation_result.h>
#include <ymod_httpclient/cluster_client.h>
#include <yplatform/util/sstream.h>

namespace yxiva { namespace hub {

class webpush_gate
{
public:
    typedef gate_result result_type;
    using handler_type = std::function<void(gate_response)>;

    webpush_gate(yplatform::reactor& reactor, const webpush_gate_settings& st);

    void send_message(const packet& packet, const handler_type& handler);

    const time_duration& send_timeout_for(const sub_t& subscription) const;

private:
    void handle_send(
        const boost::system::error_code& ec,
        yhttp::response response,
        const handler_type& handler);

    string prepare_request_url(const packet& packet);
    string prepare_request_body(
        const packet& packet,
        const string& urlencoded_webpush_subscription);
    void append_request_body_payload(yplatform::sstream& sstream, const packet& packet);

private:
    const webpush_gate_settings settings_;
    yhttp::cluster_client http_client_;
    yhttp::options http_options_;
};

}}
