#include "main_module.h"
#include "xtable/impl.h"
#include "xtable/resharding/impl.h"
#include "convey/exhaust.h"
#include "mod_log/mod_log.h"
#include "mod_placeholder.h"
#include <yxiva/core/shards/pq_updated_storage.h>
#include <yxiva/core/shards/static_storage.h>
#include <yxiva/core/shards/merging_storage.h>
#include <yxiva/core/resharding/pq_migration_storage.h>

namespace yxiva { namespace hub {

using pq_updated_shards = yxiva::shard_config::
    pq_updated_storage<ymod_pq::call, ymod_pq::future_result, ymod_pq::response_handler>;
using merged_shards = yxiva::shard_config::merging_storage;
using migrations = yxiva::resharding::pq_migration_storage<ymod_pq::call>;

}}

#include <yplatform/module_registration.h>
DEFINE_SERVICE_OBJECT_BEGIN()
DEFINE_SERVICE_OBJECT_MODULE(yxiva::hub::main_module)
DEFINE_SERVICE_OBJECT_MODULE(yxiva::hub::xtable_impl)
DEFINE_SERVICE_OBJECT_MODULE(yxiva::hub::xtable::resharding::impl)
DEFINE_SERVICE_OBJECT_MODULE(yxiva::hub::mod_log)
DEFINE_SERVICE_OBJECT_MODULE(yxiva::hub::exhaust)
DEFINE_SERVICE_OBJECT_MODULE(yxiva::hub::pq_updated_shards)
DEFINE_SERVICE_OBJECT_MODULE(yxiva::hub::merged_shards)
DEFINE_SERVICE_OBJECT_MODULE(yxiva::hub::migrations)
DEFINE_SERVICE_OBJECT_MODULE(yxiva::hub::mod_placeholder)
DEFINE_SERVICE_OBJECT_END()
