#include "error.h"

#include <boost/assign/list_of.hpp>

namespace yxiva { namespace hub {

const std::vector<string> error_category::error_names =
    boost::assign::list_of("OK")("unknown error")("auth failed")("subscriptions storage failed")(
        "service agent failed")("operation canceled")("requests collision")("no such service")(
        "service is not enabled for user")("position update failed")("position update conflict")(
        "unsubscribe failed")("gate fail")("subscription dropped")("message filtered")(
        "no subscriptions")("agent bad request")("rate limit")("push service fail")(
        "agent timeout")("service unavailable")("forbidden")("subscription deactivated")(
        "uidset and uid are in different shards")("invalid callback parameters")(
        "remote xtable fail")("resharding migrations storage failed")("resharding role mismatch")(
        "request delay queue for gid already exists")("request delay queue for gid not found")(
        "request delay queue for gid overflow")("request delay queue for gid rejects all requests")(
        "resharding bad migration state")("resharding disabled")("can't process");

const error_category& category()
{
    static const error_category category;
    return category;
}

}}
