#pragma once

#include "worker/xtasks_worker.h"
#include "worker/xtasks_service.h"
#include "xtable/xtable.h"
#include "convey/exhaust.h"
#include "settings.h"
#include "state.h"
#include "stats.h"
#include "control_module.h"

#include <yxiva/core/types.h>
#include <yxiva/core/services/decoder_interface.h>
#include <ymod_lease/node.h>
#include <ymod_paxos/node.h>
#include <sintimers/timers_queue_interface.h>
#include <ymod_webserver/server.h>
#include <yplatform/exception.h>
#include <yplatform/repository.h>
#include <yplatform/find.h>
#include <yplatform/util/tuple_unpack.h>
#include <yplatform/log.h>
#include <boost/thread.hpp>
#include <atomic>
#include <map>

namespace yxiva { namespace hub {

// Setup all xivahub submodules and API methods.
class main_module : public yplatform::module
{
public:
    main_module(yplatform::reactor& reactor, const yplatform::ptree& xml);

    void init();
    void start();
    void stop();
    void fini();

    yplatform::ptree get_stats() const;

private:
    void start_finalize_timer(bool prev_value = false);

    services::decoders_kit_ptr decoders_; // выносится в ручку /notify @@
    timers::queue_ptr timers_;            // выносится, держит сам себя @@
    std::shared_ptr<state> state_{ new state() };
    std::shared_ptr<yplatform::reactor> local_reactor_;
    std::shared_ptr<control_module> control_module_;
    timers::timer_ptr finalize_timer_; // checks finalize flag and does app shutdown
};

}}
