#pragma once

#include <yxiva/core/types.h>
#include <yxiva/core/json.h>
#include <ymod_messenger/host_info.h>
#include <yplatform/util/split.h>
#include <boost/algorithm/string/predicate.hpp>

namespace yxiva { namespace hub {

struct peer_info
{
    unsigned id = 0;
    string address;

    static peer_info from_string(const string& src)
    {
        peer_info ret;
        auto parts = yplatform::util::split(src, ",");
        if (parts.size() != 2)
        {
            throw std::runtime_error("can't convert value: \"" + src + "\" to peer_info");
        }
        try
        {
            ret.id = std::stoul(parts[0]);
        }
        catch (...)
        {
            throw std::runtime_error("can't cast value: \"" + src + "\" to peer_info");
        }
        ret.address = parts[1];
        return ret;
    }

    string to_string() const
    {
        return std::to_string(id) + "," + address;
    }

    bool operator<(const peer_info& other) const
    {
        return address < other.address;
    }

    bool operator==(const peer_info& other) const
    {
        return address == other.address;
    }

    bool is_local() const
    {
        return boost::starts_with(address, "localhost");
    }
};

inline void ptree_convert(const yplatform::ptree& ptree, peer_info& out)
{
    out = peer_info::from_string(ptree.get_value<string>());
}

}}
