#pragma once

#include <yxiva/core/resharding/migration.h>
#include <yxiva/core/types.h>

namespace yxiva { namespace hub { namespace resharding {

class controller
{
public:
    enum class request_reaction
    {
        delay,
        reject
    };

    enum class role
    {
        master,
        slave,
        unknown // In case of fallback.
    };

    using set_state_callback =
        std::function<void(const error_code&, yxiva::resharding::migration::state_type)>;
    using list_migrations_callback =
        std::function<void(const error_code&, const yxiva::resharding::migrations&)>;

    virtual ~controller()
    {
    }

    virtual void prepare_migration(
        task_context_ptr ctx,
        gid_t gid,
        role expected_role,
        role actual_role,
        const string& master_address,
        const set_state_callback& cb) = 0;
    virtual void start_migration(
        task_context_ptr ctx,
        gid_t gid,
        role expected_role,
        role actual_role,
        const string& master_address,
        request_reaction reaction,
        const set_state_callback& cb) = 0;
    virtual void finalize_migration(
        task_context_ptr ctx,
        gid_t gid,
        role expected_role,
        role actual_role,
        const string& master_address,
        const set_state_callback& cb) = 0;
    virtual void abort_migration(
        task_context_ptr ctx,
        gid_t gid,
        role expected_role,
        role actual_role,
        const string& master_address,
        const set_state_callback& cb) = 0;
    virtual void list_migrations(task_context_ptr ctx, const list_migrations_callback& cb) = 0;
};

}}}
