#pragma once

#include "worker/xtasks_worker.h"
#include "worker/xtasks_service.h"
#include "xtable/xtable.h"
#include "convey/exhaust.h"
#include "settings.h"
#include "stats.h"
#include "resharding/controller.h"

#include <yxiva/core/types.h>
#include <ymod_messenger/module.h>
#include <ymod_lease/node.h>
#include <ymod_paxos/node.h>
#include <ymod_pq/call.h>
#include <yplatform/exception.h>

namespace yxiva { namespace hub {

class control_module;

struct state
{
    shared_ptr<XTable> xtable;
    exhaust_ptr exhaust;
    settings_ptr settings;

    boost::shared_ptr<ymod_xtasks::xtasks> xtasks;
    boost::shared_ptr<ymod_xstore::xstore> xstore;
    std::shared_ptr<ymod_messenger::module> netch;
    std::shared_ptr<ymod_messenger::module> lease_netch;
    std::shared_ptr<ymod_messenger::module> sync_netch;
    boost::shared_ptr<ymod_paxos::node> paxos_node;
    boost::shared_ptr<ymod_lease::node> lease_node;
    boost::shared_ptr<ymod_lease::node> leasemeta;
    boost::shared_ptr<hub::mod_log> transport_log;

    std::shared_ptr<hub::xtasks_service> xtasks_service;
    std::shared_ptr<hub::xtasks_worker> xtasks_worker;
    std::weak_ptr<control_module> controller; // state is stored in controller

    boost::shared_ptr<ymod_pq::cluster_call> pq_xtable;
    boost::shared_ptr<ymod_pq::cluster_call> pq_xstore;
    boost::shared_ptr<ymod_pq::cluster_call> pq_batch;

    module_stats stats;
};

}}
