#pragma once

#include "settings.h"
#include "convey/exhaust.h"
#include "xtable/xtable.h"
#include <ymod_xtasks/xtasks.h>
#include <ymod_xstore/interface.h>
#include <yplatform/log.h>
#include <boost/noncopyable.hpp>
#include <atomic>

namespace yxiva { namespace hub { namespace worker {

using timer = time_traits::timer;

struct coro_root : public boost::noncopyable
{
    ::yxiva::hub::worker::settings settings;
    std::atomic<unsigned> generation = { 0 };
    std::atomic_bool lazy_mode = { false };
    std::atomic_bool progressive_retry_enabled = { true };
    std::atomic<unsigned> total_jobs = { 0 };
    std::atomic<unsigned> total_retry_jobs_xstore = { 0 };
    std::atomic<unsigned> total_retry_jobs_convey = { 0 };
    std::atomic<unsigned> total_tasks = { 0 };
    string name;

    std::shared_ptr<ymod_xtasks::xtasks> xtasks;
    std::shared_ptr<ymod_xstore::xstore> xstore;
    std::shared_ptr<XTable> xtable;
    exhaust_ptr exhaust;
    shared_ptr<mod_log> transport_log;

    std::unique_ptr<timer> exec_timer;
    std::unique_ptr<timer> alive_timer;

    yplatform::log::source logger;

    bool expired(unsigned generation) const
    {
        return generation != this->generation;
    }
};

}}}
