#pragma once

#include <yxiva/core/types.h>
#include <yplatform/ptree.h>
#include <atomic>

namespace yxiva { namespace hub { namespace worker {

struct settings
{
    struct retry
    {
        time_t start_interval;
        time_t backoff_coefficient;
        time_t end_interval;

        void read(const yplatform::ptree& conf)
        {
            start_interval = conf.get<time_t>("start_interval");
            backoff_coefficient = conf.get<time_t>("backoff_coefficient");
            end_interval = conf.get<time_t>("end_interval");

            if (backoff_coefficient < 2)
            {
                throw std::domain_error("backoff_coefficient must be greater than 1");
            }
        }
    };

    unsigned max_tasks;
    unsigned lazy_factor;
    unsigned xstore_read_limit;
    time_duration alive_interval;
    time_duration exec_interval;
    time_duration xtable_update_timeout;
    time_duration kill_timeout;
    unsigned default_delay; // TODO rename
    retry retry_http;
    retry retry_mobile;
    retry retry_webpush;
    bool progressive_retry_enabled;

    void load(const yplatform::ptree& conf)
    {
        max_tasks = conf.get<unsigned>("max_tasks");
        lazy_factor = conf.get<unsigned>("lazy_factor");
        xstore_read_limit = conf.get<unsigned>("xstore_read_limit");
        alive_interval = conf.get<time_duration>("alive_interval");
        exec_interval = conf.get<time_duration>("exec_interval");
        xtable_update_timeout = conf.get<time_duration>("xtable_update_timeout");
        kill_timeout = conf.get<time_duration>("kill_timeout");
        default_delay = conf.get<unsigned>("default_delay", 5);
        retry_http.read(conf.get_child("retry.http"));
        retry_mobile.read(conf.get_child("retry.mobile"));
        retry_webpush.read(conf.get_child("retry.webpush"));
        progressive_retry_enabled = conf.get<bool>("progressive_retry_enabled", true);

        if (kill_timeout <= 2 * xtable_update_timeout)
        {
            throw std::domain_error("too small xtable_update_timeout");
        }
    }
};

}}}
