#pragma once

#include "xtask_context.h"
#include "settings.h"
#include <ymod_xstore/interface.h>

namespace yxiva { namespace hub { namespace worker {

void decode_messages(
    const ymod_xstore::entries_list_ptr& entries,
    std::vector<shared_ptr<yxiva::message>>& messages);
void prepare_jobs(xtask_context_ptr context, yplatform::log::source& logger);
bool prepare_job(
    const xtask_context_ptr& ctx,
    yplatform::log::source& logger,
    const std::vector<shared_ptr<yxiva::message>>& messages,
    xtask_context::job& job);

time_t retry_interval_for(const sub_t& subscription, const settings& settings);
const settings::retry& retry_for(const sub_t& subscription, const settings& settings);

}}}
