#pragma once

#include "../xtable/xtable.h"
#include "../mod_log/mod_log.h"
#include <yxiva/core/types.h>
#include <yxiva/core/message.h>
#include <yxiva/core/filter.h>
#include <yplatform/task_context.h>
#include <yplatform/util/ntimer.h>
#include <yplatform/spinlock.h>
#include <ymod_xtasks/task.h>
#include <boost/shared_ptr.hpp>
#include <atomic>

namespace yxiva { namespace hub { namespace worker {

using clock = time_traits::clock;

class xtask_context : public yplatform::task_context
{
public:
    xtask_context(ymod_xtasks::task const& task, const shared_ptr<mod_log>& transport_log)
    {
        init(task, transport_log);
    }

    xtask_context(
        string const& id,
        ymod_xtasks::task const& task,
        const shared_ptr<mod_log>& transport_log)
        : yplatform::task_context(id)
    {
        init(task, transport_log);
    }

    const string& get_name() const
    {
        static const string CONTEXT_NAME = "yxiva_hub_xtask_context";
        return CONTEXT_NAME;
    }

    void init(ymod_xtasks::task const& init_task, const shared_ptr<mod_log>& init_transport_log)
    {
        task = init_task;
        transport_log = init_transport_log;
        timings.reserve(10);
    }

    struct send_step
    {
        shared_ptr<yxiva::message> message;
        ::yxiva::filter::action action;
    };

    struct job
    {
        job(sub_t& subscription) : subscription(subscription)
        {
        }

        std::vector<send_step> steps;
        sub_t& subscription;
        local_id_t final_id;
        size_t step = 0;
        bool retry = false;
        bool recreate_task = false;
        time_t retry_interval = 0;
        time_t final_event_ts = 0;

        bool finished()
        {
            return step >= steps.size();
        }

        void finish()
        {
            step = steps.size();
        }

        string steps_to_string()
        {
            std::stringstream ss;
            for (auto& step : steps)
            {
                ss << step.message->local_id;
                if (step.action == filter::action::send_silent)
                {
                    ss << "s";
                }
                else if (step.action == filter::action::skip)
                {
                    ss << "!";
                }
                ss << " ";
            }
            return ss.str();
        }
    };

    ymod_xtasks::task task;
    sub_list subscriptions;
    sub_list subscriptions_for_retry;
    std::vector<shared_ptr<yxiva::message>> messages;
    std::vector<job> jobs;
    std::atomic<unsigned> jobs_count = { 0 };
    std::atomic<bool> has_fails = { false };
    bool delay_task = false;
    std::vector<uint64_t> timings;
    time_point start_time;
    time_point deadline;
    // Minimal retry interval among subscriptions, which
    // were to be retried in the future (their retry_interval
    // has not expired at the moment of task execution).
    time_t filtered_retry_interval = 0;
    shared_ptr<mod_log> transport_log;
};

typedef boost::shared_ptr<xtask_context> xtask_context_ptr;

}}}
