#pragma once

#include "settings.h"
#include "main_coro.h"
#include <yxiva/core/types.h>
#include <ymod_lease/node.h>
#include <yplatform/module.h>
#include <yplatform/find.h>

namespace yxiva { namespace hub {
namespace worker {

/// xtasks_worker processes xtasks by splitting them to parallel convey jobs
class xtasks_worker : public yplatform::module
{
public:
    void init(yplatform::ptree const& conf)
    {
        using yplatform::exists;
        using yplatform::find;

        coro_root_.xtable = find<XTable, std::shared_ptr>(conf.get("xtable_module", "xtable"));
        coro_root_.xtasks =
            find<ymod_xtasks::xtasks, std::shared_ptr>(conf.get("xtasks_module", "xtasks"));
        coro_root_.xstore =
            find<ymod_xstore::xstore, std::shared_ptr>(conf.get("xstore_module", "xstore"));

        coro_root_.exhaust = find<exhaust>("exhaust");
        coro_root_.transport_log = yplatform::find<mod_log>("xivahub_log");

        // @todo generate own name?
        auto lease_node = find<ymod_lease::node>(conf.get("lease_node", "lease_node"));
        coro_root_.name = lease_node->node_id();

        coro_root_.settings.load(conf);

        auto reactor = yplatform::global_net_reactor;
        coro_root_.alive_timer.reset(new timer(*reactor->io()));
        coro_root_.exec_timer.reset(new timer(*reactor->io()));

        coro_root_.logger = logger();
        coro_root_.progressive_retry_enabled = coro_root_.settings.progressive_retry_enabled;
    }

    void start()
    {
        auto new_generation = ++coro_root_.generation;
        main_loop_coro main_loop(coro_root_, new_generation);
        alive_coro alive(coro_root_, new_generation);
        main_loop();
        alive();
    }

    void stop()
    {
        ++coro_root_.generation;
    }

    bool lazy_mode() const
    {
        return coro_root_.lazy_mode.load();
    }

    void lazy_mode(bool value)
    {
        coro_root_.lazy_mode = value;
    }

    yplatform::ptree get_stats() const
    {
        yplatform::ptree result;
        result.put("tasks", coro_root_.total_tasks.load());
        result.put("jobs", coro_root_.total_jobs.load());
        result.put("retry_jobs_xstore", coro_root_.total_retry_jobs_xstore.load());
        result.put("retry_jobs_convey", coro_root_.total_retry_jobs_convey.load());
        return result;
    }

    void toggle_progressive_retry(bool enabled)
    {
        YLOG_LOCAL(info) << (enabled ? "en" : "dis") << "abling progressive retry";
        coro_root_.progressive_retry_enabled = enabled;
    }

private:
    worker::coro_root coro_root_;
};

}

using xtasks_worker = worker::xtasks_worker;

}}
