#pragma once

#include <ymod_pq/response_handler.h>

namespace yxiva { namespace hub { namespace pq_handlers {

class batch_del : public ymod_pq::response_handler
{
    std::vector<string> ids_;
    string current_;

public:
    void handle_cell(unsigned /*row*/, unsigned col, const string& value, bool is_null) override
    {
        if (col == 0 && !is_null)
        {
            current_ = value;
        }
    }

    void handle_row_end(unsigned /*row*/) override
    {
        if (current_.size())
        {
            ids_.push_back(std::move(current_));
            current_ = string();
        }
    }

    unsigned column_count() const override
    {
        return 1;
    }

    const std::vector<string>& get_data()
    {
        return ids_;
    }
};

}}}
