#pragma once

#include <yxiva/core/platforms.h>
#include <boost/lexical_cast.hpp>
#include <ymod_pq/response_handler.h>
#include "../istorage.h"

namespace yxiva { namespace hub { namespace pq_handlers {

class batch_list : public ymod_pq::response_handler
{
    const string service_;

    sub_t current_;
    sub_list list_;

public:
    enum
    {
        uid,
        id,
        callback,
        filter,
        extra_data,
        client,
        ttl,
        session_key,

        init_local_id, // bigint
        init_time,     // int
        ack_local_id,  // bigint
        ack_time,      // int
        smart_notify,  // bool
        platform,
        device,

        column_cnt
    };

    batch_list(const string& service) : service_(service)
    {
    }

    void handle_cell(unsigned /*row*/, unsigned col, const string& value, bool is_null)
    {
        switch (col)
        {
        case uid:
            current_.uid = value;
            break;
        case id:
            current_.id = value;
            break;
        case callback:
            current_.callback_url = value;
            break;
        case filter:
            current_.filter = value;
            break;
        case extra_data:
            current_.extra_data = value;
            break;
        case client:
            current_.client = value;
            break;
        case ttl:
            current_.ttl = is_null || value.empty() ? 0 : boost::lexical_cast<ttl_t>(value);
            break;
        case session_key:
            current_.session_key = value;
            break;
        case init_local_id:
            current_.init_local_id =
                is_null || value.empty() ? 0 : boost::lexical_cast<local_id_t>(value);
            break;
        case init_time:
            current_.init_time =
                is_null || value.empty() ? 0 : boost::lexical_cast<std::time_t>(value);
            break;
        case ack_local_id:
            current_.ack_local_id =
                is_null || value.empty() ? 0 : boost::lexical_cast<local_id_t>(value);
            break;
        case ack_time:
            current_.ack_time =
                is_null || value.empty() ? 0 : boost::lexical_cast<std::time_t>(value);
            break;
        case smart_notify:
            current_.smart_notify = (value == "t");
            break;
        case platform:
            current_.platform = platform::resolve_alias(value).name;
            break;
        case device:
            current_.device = value;
            break;
        }
    }

    void handle_row_end(unsigned /*row*/)
    {
        current_.service = service_;
        list_.push_back(current_);
        current_ = sub_t();
    }

    unsigned column_count() const
    {
        return column_cnt;
    }

    sub_list move_data()
    {
        return std::move(list_);
    }
};

}}}
