#pragma once

#include <yxiva/core/subscriptions.h>
#include <yxiva/core/platforms.h>
#include <boost/lexical_cast.hpp>
#include <ymod_pq/response_handler.h>

namespace yxiva { namespace hub { namespace pq_handlers {

class list : public ymod_pq::response_handler
{
    sub_t current_;
    sub_list list_;
    const string uid_;
    const string service_;

public:
    enum
    {
        uid,
        service,
        id,
        callback,
        filter,
        extra_data,
        client,
        ttl,
        session_key,

        init_local_id, // bigint
        init_time,     // int
        ack_local_id,  // bigint
        ack_time,      // int
        smart_notify,  // bool
        platform,
        device,
        bb_connection_id,
        next_retry_time,
        retry_interval,
        ack_event_ts,

        column_cnt
    };

    list(const user_id& uid) : uid_(uid)
    {
    }

    list(const service_name& service) : service_(service)
    {
    }

    list(const string& uid, const string& service) : uid_(uid), service_(service)
    {
    }

    void handle_cell(unsigned /*row*/, unsigned col, const string& value, bool is_null)
    {
        switch (col)
        {
        case uid:
            current_.uid = is_null ? uid_ : value;
            break;
        case service:
            current_.service = is_null ? service_ : value;
            break;
        case id:
            current_.id = value;
            break;
        case callback:
            current_.callback_url = value;
            break;
        case filter:
            current_.filter = value;
            break;
        case extra_data:
            current_.extra_data = value;
            break;
        case client:
            current_.client = value;
            break;
        case ttl:
            current_.ttl = is_null || value.empty() ? 0 : boost::lexical_cast<ttl_t>(value);
            break;
        case session_key:
            current_.session_key = value;
            break;
        case init_local_id:
            current_.init_local_id =
                is_null || value.empty() ? 0 : boost::lexical_cast<local_id_t>(value);
            break;
        case init_time:
            current_.init_time =
                is_null || value.empty() ? 0 : boost::lexical_cast<std::time_t>(value);
            break;
        case ack_local_id:
            current_.ack_local_id =
                is_null || value.empty() ? 0 : boost::lexical_cast<local_id_t>(value);
            break;
        case ack_time:
            current_.ack_time =
                is_null || value.empty() ? 0 : boost::lexical_cast<std::time_t>(value);
            break;
        case smart_notify:
            current_.smart_notify = (value == "t");
            break;
        case platform:
            current_.platform = platform::resolve_alias(value).name;
            break;
        case device:
            current_.device = value;
            break;
        case bb_connection_id:
            current_.bb_connection_id = value;
            break;
        case next_retry_time:
            current_.next_retry_time =
                is_null || value.empty() ? 0 : boost::lexical_cast<std::time_t>(value);
            break;
        case retry_interval:
            current_.retry_interval = is_null || value.empty() ?
                0 :
                boost::lexical_cast<time_traits::duration::rep>(value);
            break;
        case ack_event_ts:
            current_.ack_event_ts =
                is_null || value.empty() ? 0 : boost::lexical_cast<std::time_t>(value);
            break;
        }
    }

    void handle_row_end(unsigned /*row*/)
    {
        list_.push_back(current_);
        current_ = sub_t();
    }

    unsigned column_count() const
    {
        return column_cnt;
    }

    sub_list move_data()
    {
        return std::move(list_);
    }
};

}}}
