#pragma once

#include <yxiva/core/subscriptions.h>
#include <yxiva/core/platforms.h>
#include <boost/lexical_cast.hpp>
#include <ymod_pq/response_handler.h>

namespace yxiva { namespace hub { namespace pq_handlers {

class list_no_acks : public ymod_pq::response_handler
{
    sub_t current_;
    sub_list list_;

public:
    enum
    {
        id,
        callback,
        filter,
        extra_data,
        client,
        ttl,
        session_key,
        init_local_id,
        init_time,
        platform,
        device,
        bb_connection_id,
        column_cnt
    };

    void handle_cell(unsigned /*row*/, unsigned col, const string& value, bool is_null)
    {
        switch (col)
        {
        case id:
            current_.id = value;
            break;
        case callback:
            current_.callback_url = value;
            break;
        case filter:
            current_.filter = value;
            break;
        case extra_data:
            current_.extra_data = value;
            break;
        case client:
            current_.client = value;
            break;
        case ttl:
            current_.ttl = is_null || value.empty() ? 0 : boost::lexical_cast<ttl_t>(value);
            break;
        case session_key:
            current_.session_key = value;
            break;
        case init_local_id:
            current_.init_local_id =
                is_null || value.empty() ? 0 : boost::lexical_cast<local_id_t>(value);
            break;
        case init_time:
            current_.init_time =
                is_null || value.empty() ? 0 : boost::lexical_cast<std::time_t>(value);
            break;
        case platform:
            current_.platform = platform::resolve_alias(value).name;
            break;
        case device:
            current_.device = value;
            break;
        case bb_connection_id:
            current_.bb_connection_id = value;
            break;
        }
    }

    void handle_row_end(unsigned /*row*/)
    {
        list_.push_back(current_);
        current_ = sub_t();
    }

    unsigned column_count() const
    {
        return column_cnt;
    }

    sub_list move_data()
    {
        return std::move(list_);
    }
};

}}}
