#pragma once

#include <boost/lexical_cast.hpp>
#include <ymod_pq/response_handler.h>
#include <yxiva/core/iabstract.h>

namespace yxiva { namespace hub { namespace pq_handlers {

class update
    : public ymod_pq::response_handler
    , public iabstract
{
    bool exists_;
    local_id_t local_id_;

public:
    update() : exists_(false), local_id_(0)
    {
    }

    void handle_cell(unsigned /*row*/, unsigned /*col*/, const string& value, bool is_null)
    {
        exists_ = !is_null;
        if (exists_)
        {
            local_id_ = value.empty() ? 0 : boost::lexical_cast<local_id_t>(value);
        }
    }

    void handle_row_end(unsigned /*row*/)
    {
    }

    unsigned column_count() const
    {
        return 1;
    }

    bool row_exists() const
    {
        return exists_;
    }

    local_id_t local_id() const
    {
        return local_id_;
    }
};

}}}
