#pragma once

#include "query.h"
#include <xtable/xtable.h>

namespace yxiva { namespace hub { namespace xtable { namespace resharding {

template <typename Impl>
class interceptor : public XTable
{
    inline Impl* impl()
    {
        return static_cast<Impl*>(this);
    }

public:
    virtual void subscribe(
        task_context_ptr ctx,
        const sub_t& subscription,
        const subscribe_callback_t& callback) override
    {
        impl()->intercept(
            ctx, subscribe_traits{}, gid_from_uid(subscription.uid), callback, subscription);
    }
    virtual void subscribe_mobile(
        task_context_ptr ctx,
        const string& uid,
        const string& service,
        const filter_t& filter,
        const string& callback_url,
        const string& extra_data,
        const string& client,
        const string& device_uuid,
        const ttl_t ttl,
        const string& subscription_id,
        const local_id_t init_local_id,
        const string& platform,
        const string& device,
        const string& bb_connection_id,
        const subscribe_callback_t& callback) override
    {
        impl()->intercept(
            ctx,
            subscribe_mobile_traits{},
            gid_from_uid(uid),
            callback,
            uid,
            service,
            filter,
            callback_url,
            extra_data,
            client,
            device_uuid,
            ttl,
            subscription_id,
            init_local_id,
            platform,
            device,
            bb_connection_id);
    }
    virtual void unsubscribe(
        task_context_ptr ctx,
        const string& uid,
        const string& service,
        const string& subscription_id,
        const callback_t& callback) override
    {
        impl()->intercept(
            ctx, unsubscribe_traits{}, gid_from_uid(uid), callback, uid, service, subscription_id);
    }
    virtual void unsubscribe_mobile(
        task_context_ptr ctx,
        const string& uid,
        const string& service,
        const string& device_uuid,
        const callback_t& callback) override
    {
        impl()->intercept(
            ctx,
            unsubscribe_mobile_traits{},
            gid_from_uid(uid),
            callback,
            uid,
            service,
            device_uuid);
    }
    virtual void unsubscribe_overlapped(
        task_context_ptr ctx,
        const string& uid,
        const string& service,
        const string& subscription_id,
        const unsigned overlap_sec,
        const callback_t& callback) override
    {
        impl()->intercept(
            ctx,
            unsubscribe_overlapped_traits{},
            gid_from_uid(uid),
            callback,
            uid,
            service,
            subscription_id,
            overlap_sec);
    }
    virtual void batch_unsubscribe(
        task_context_ptr ctx,
        const string& uid,
        const string& service,
        const std::vector<string>& subscription_ids,
        std::time_t init_not_after,
        const batch_del_callback_t& callback) override
    {
        impl()->intercept(
            ctx,
            batch_unsubscribe_traits{},
            gid_from_uid(uid),
            callback,
            uid,
            service,
            subscription_ids,
            init_not_after);
    }
    virtual void find(
        task_context_ptr ctx,
        const string& uid,
        const string& service,
        const find_options& opts,
        const find_callback_t& callback) override
    {
        impl()->execute(&XTable::find, ctx, uid, service, opts, callback);
    }
    virtual void batch_find(
        task_context_ptr ctx,
        const batch_keys& keys,
        const string& service,
        const find_options& opts,
        const batch_find_callback_t& callback) override
    {
        // Help the compiler to locate the right overload.
        auto batch_find_ptr = static_cast<void (XTable::*)(
            task_context_ptr,
            const batch_keys&,
            const string&,
            const find_options&,
            const batch_find_callback_t&)>(&XTable::batch_find);
        impl()->execute(batch_find_ptr, ctx, keys, service, opts, callback);
    }
    virtual void update(
        task_context_ptr ctx,
        const string& uid,
        const string& service,
        const string& subscription_id,
        local_id_t old_local_id,
        local_id_t new_local_id,
        time_t retry_interval,
        time_t ack_event_ts,
        const update_callback_t& callback) override
    {
        impl()->intercept(
            ctx,
            update_traits{},
            gid_from_uid(uid),
            callback,
            uid,
            service,
            subscription_id,
            old_local_id,
            new_local_id,
            retry_interval,
            ack_event_ts);
    }
    virtual void add_broken_subscription(
        task_context_ptr ctx,
        const string& platform,
        const string& subscription_id,
        std::time_t timestamp,
        const add_callback_t& callback) override
    {
        impl()->execute(
            &XTable::add_broken_subscription, ctx, platform, subscription_id, timestamp, callback);
    }
    virtual void find_uidset(
        task_context_ptr ctx,
        const string& uidset,
        const string& service,
        const find_options& opts,
        const find_callback_t& callback) override
    {
        impl()->execute(&XTable::find_uidset, ctx, uidset, service, opts, callback);
    }
    virtual void update_uidset(
        task_context_ptr ctx,
        const string& uidset,
        const string& service,
        const string& old_cb,
        const string& new_cb,
        const update_uidset_callback_t& callback) override
    {
        impl()->intercept(
            ctx,
            update_uidset_traits{},
            gid_from_uid(uidset),
            callback,
            uidset,
            service,
            old_cb,
            new_cb);
    }
    virtual void update_callback(
        task_context_ptr ctx,
        const string& uid,
        const string& service,
        const string& subscription_id,
        const string& old_cb,
        const string& new_cb,
        const update_uidset_callback_t& callback) override
    {
        impl()->intercept(
            ctx,
            update_callback_traits{},
            gid_from_uid(uid),
            callback,
            uid,
            service,
            subscription_id,
            old_cb,
            new_cb);
    }
    virtual void batch_find(
        task_context_ptr ctx,
        const string& uid,
        const std::vector<string>& services,
        const find_options& opts,
        const find_callback_t& callback) override
    {
        auto batch_find_ptr = static_cast<void (XTable::*)(
            task_context_ptr,
            const string&,
            const std::vector<string>&,
            const find_options&,
            const find_callback_t&)>(&XTable::batch_find);
        impl()->execute(batch_find_ptr, ctx, uid, services, opts, callback);
    }
};

}}}}