#include "query.h"

namespace yxiva { namespace hub { namespace xtable { namespace resharding {

static const string subscribe = "subscribe";
static const string subscribe_mobile = "subscribe_mobile";
static const string unsubscribe = "unsubscribe";
static const string unsubscribe_mobile = "unsubscribe_mobile";
static const string unsubscribe_overlapped = "unsubscribe_overlapped";
static const string batch_unsubscribe = "batch_unsubscribe";
static const string update = "update";
static const string update_uidset = "update_uidset";
static const string update_callback = "update_callback";

string query_type_to_string(query_type t)
{
    switch (t)
    {
    case query_type::subscribe:
        return subscribe;
    case query_type::subscribe_mobile:
        return subscribe_mobile;
    case query_type::unsubscribe:
        return unsubscribe;
    case query_type::unsubscribe_mobile:
        return unsubscribe_mobile;
    case query_type::unsubscribe_overlapped:
        return unsubscribe_overlapped;
    case query_type::batch_unsubscribe:
        return batch_unsubscribe;
    case query_type::update:
        return update;
    case query_type::update_uidset:
        return update_uidset;
    case query_type::update_callback:
        return update_callback;
    default:
        return "unknown";
    }
}

query_type query_type_from_string(const string& s)
{
    if (s == subscribe) return query_type::subscribe;
    if (s == subscribe_mobile) return query_type::subscribe_mobile;
    if (s == unsubscribe) return query_type::unsubscribe;
    if (s == unsubscribe_mobile) return query_type::unsubscribe_mobile;
    if (s == unsubscribe_overlapped) return query_type::unsubscribe_overlapped;
    if (s == batch_unsubscribe) return query_type::batch_unsubscribe;
    if (s == update) return query_type::update;
    if (s == update_uidset) return query_type::update_uidset;
    if (s == update_callback) return query_type::update_callback;
    throw std::invalid_argument(string("invalid resharding query type value ") + s);
}

}}}}
